<?php
namespace model;

class Home extends \Pawn\Model
{	
	// Administration
	const sortColumn = 'ts_create';
	const sortAscending = 0;
	
	public function listing()
	{
		return array
		(
			'model_id'	=>	call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id, false)->fetch()->__toString(),
			'action'	=>	\lib\Lang::get($this->action),
			'model'		=>	\lib\Lang::get('admin', $this->model, 'instance'),
			'ts_create'	=>	\lib\Lang::get('edited_by', array
			(
				'date'	=>	\Pawn::get_date($this->ts_edit),
				'user'	=>	User::get('WHERE id=?', $this->user_id)->fetch()
			))
		);
	}
	
	public static function bulk()
	{
		return array();
		
		if(\lib\Session::user()->level < 5)
		{
			return array();
		}
		
		return array
		(
			'undo'	=>	true
		);
	}
	
	// View
	public static function model_vars($vars)
	{
		$vars['about'] = \Pawn::get_date();
		$vars['subheading'] = \lib\Lang::get('last_actions');
		
		return $vars;
	}
	
	// Validation
	public function columns()
	{
		return array
		(
			'action'	=>	array('text', array()),
			'model'		=>	array('FieldObject', array())
		);
	}
	
	public function fields($action, $fields)
	{
		$raw = $fields['model']->assoc;
		
		if(!$fields['model'])
		{
			return false;
		}
		
		unset($raw['id'], $raw['trash'], $raw['ts_create'], $raw['ts_edit']);
		
		return array
		(
			'action'	=>	$fields['action'],
			'model'		=>	substr(get_class($fields['model']), 6),
			'model_id'	=>	$fields['model']->id,
			'user_id'	=>	\lib\Session::user()->id,
			'raw'		=>	serialize($raw)
		);
	}
	
	// Migration
	public static function migration($model_name, $current)
	{
		if($current && version_compare(UPDATE, '1.1.1', '<'))
		{
			\lib\db::query('DELETE FROM `'.PREFIX.'home` WHERE `model` IS NULL OR `model_id` IS NULL');
		}
		
		return array
		(
			array('CREATE', array
			(
				'action'	=>	'VARCHAR(32)',
				'model'		=>	'VARCHAR(32)',
				'model_id'	=>	'INT UNSIGNED',
				'user_id'	=>	'INT UNSIGNED',
				'raw'		=>	'TEXT'
			))
		);
	}
	
	// Undo
	public function undo()
	{
		switch($this->action)
		{
			case 'create':
				$instance = call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id)->fetch()->delete();
				
				$this->delete();
			break;
			case 'edit':
				$instance = call_user_func(array('\\model\\'.$this->model, 'get'), 'WHERE id=?', $this->model_id)->fetch();
				
				$raw = unserialize($this->raw);
				
				foreach($raw as $key=>$value)
				{
					$instance->$key = $value;
				}
				
				$this->delete();
			break;
			case 'trash':
				$trash = \model\Trash::get('WHERE model_id=? AND model=?', array($this->model_id, $this->model))->fetch()->restore();
			break;
		}
	}
}

// Initialize
$pageSize = 15;

if(!defined('UPDATE') && ($rows = Home::num_rows()) > $pageSize)
{
	Home::get('ORDER BY id ASC LIMIT 0,'.($rows - $pageSize), array(), false, 'delete');
}